-- Create the database
CREATE DATABASE IF NOT EXISTS cardan;

-- Switch to the new database
USE cardan;

-- Drop existing tables if they exist
DROP TABLE IF EXISTS PaintRal;
DROP TABLE IF EXISTS Paint;
DROP TABLE IF EXISTS Ral;

-- Create Paint table
CREATE TABLE Paint (
    id INT PRIMARY KEY AUTO_INCREMENT,
    price INT, 
    grams INT, 
    shine VARCHAR(50), 
    photo VARCHAR(255), 
    base VARCHAR(50)
);

-- Create RAL table
CREATE TABLE Ral (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100)
);

-- Create join table linking Paints and RALs
CREATE TABLE PaintRal (
    paint_id INT,
    ral_id INT,
    PRIMARY KEY (paint_id, ral_id),
    FOREIGN KEY (paint_id) REFERENCES Paint(id) ON DELETE CASCADE,
    FOREIGN KEY (ral_id) REFERENCES Ral(id) ON DELETE CASCADE
);

-- Insert Paints
INSERT INTO Paint (price, grams, shine, photo, base) VALUES
(1299, 500, 'Hypergloss',   'https://dummyimage.com/200x200/FFCC00/000000&text=RAL1003', 'Zinc-Tek'),
(1599, 450, 'MatteSilk',    'https://dummyimage.com/200x200/FF7F00/000000&text=RAL2008', 'Carbon-Flex'),
(1099, 300, 'NeoChrome',    'https://dummyimage.com/200x200/FF0000/000000&text=RAL3020', 'Nano-Tint'),
(1899, 520, 'UltraMat',     'https://dummyimage.com/200x200/0000FF/000000&text=RAL5015', 'Iron-Gleam'),
(999,  280, 'GloomLuster',  'https://dummyimage.com/200x200/00FF00/000000&text=RAL6018', 'TitanOxide'),
(1399, 350, 'LiquidVelvet', 'https://dummyimage.com/200x200/D3D3D3/000000&text=RAL7035', 'Silicore'),
(1699, 480, 'Dreamcoat',    'https://dummyimage.com/200x200/111111/FFFFFF&text=RAL9011', 'PlastiHue');

-- Insert RAL colors
INSERT INTO Ral (name) VALUES
-- Yellow
('RAL 1003 – Signalgelb'),
('RAL 1021 – Rapsgelb'),
('RAL 1018 – Zinkgelb'),
('RAL 1007 – Narzissengelb'),
-- Orange
('RAL 2008 – Hellrotorange'),
('RAL 2003 – Pastellorange'),
('RAL 2011 – Tieforange'),
('RAL 2000 – Gelborange'),
-- Red
('RAL 3020 – Verkehrsrot'),
('RAL 3000 – Feuerrot'),
('RAL 3001 – Signalrot'),
('RAL 3002 – Karminrot'),
-- Blue
('RAL 5015 – Himmelblau'),
('RAL 5002 – Ultramarinblau'),
('RAL 5010 – Enzianblau'),
('RAL 5005 – Signalblau'),
-- Green
('RAL 6018 – Gelbgrün'),
('RAL 6017 – Maigrün'),
('RAL 6002 – Laubgrün'),
('RAL 6005 – Moosgrün'),
-- Grey
('RAL 7035 – Lichtgrau'),
('RAL 7030 – Steingrau'),
('RAL 7042 – Verkehrsgrau A'),
('RAL 7047 – Telegrau 4'),
-- Black
('RAL 9011 – Graphitschwarz'),
('RAL 9005 – Tiefschwarz'),
('RAL 9017 – Verkehrsschwarz'),
('RAL 9021 – Teerschwarz');

-- Link each paint to 4 matching RALs
INSERT INTO PaintRal (paint_id, ral_id) VALUES
(1, 1), (1, 2), (1, 3), (1, 4),
(2, 5), (2, 6), (2, 7), (2, 8),
(3, 9), (3,10), (3,11), (3,12),
(4,13), (4,14), (4,15), (4,16),
(5,17), (5,18), (5,19), (5,20),
(6,21), (6,22), (6,23), (6,24),
(7,25), (7,26), (7,27), (7,28);
